﻿//Class ShapeCube
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace ShapePolymorphism
{
    public class ShapeCube : Shape3D
    {
        private double length;

        public double Length
        {
            get { return length; }
            set
            {
                if (value >= 0)
                {
                    length = value;
                    //also CalculateArea and CalculateVolume
                    Area();
                    Volume();
                } else
                {
                    MessageBox.Show("Cube side must be positive number", "Invalid number format",
                            MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
        }//end Length


        //finds surface area of sphere
        public override double Area()
        {
            return 6 * length * length;
        }//End Area

        //finds volume of sphere
        public override double Volume()
        {
            return length * length * length;
        }//End Volume

        public override double Side()
        {
            return length;
        }//End Side

        public ShapeCube()
        {
            Name = "Cube";
        }//End constructor

        public override string ToString()
        {
            return "P1.Shape3D." + Name;
        }//End toString
    }//End class
}//End namespace
